﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using UnityEngine.SceneManagement;

public class Player : MonoBehaviour {

	public float speed;
	public GameObject ps;

	private Vector3 direction;

	private int score = 0;
	private int health = 10;

	private bool isPaused = false;
	private bool onTerrain = true;

	public Text scoreText;
	public Text healthText;
	public RawImage imageShow;


	public Animator playerAnim;

	public Rigidbody Aj;


	void Start () {
		
		PlayerStats.Score = 0;
		direction = Vector3.zero;

		playerAnim = GetComponent<Animator> ();
		Aj = GetComponent<Rigidbody> (); 

	}

	void Update () {

		if (transform.position.y <= 0.2f) {
			onTerrain = true;
		} else onTerrain = false;

		if (isPaused) {
			Time.timeScale = 0.0f;
		} else {
			Time.timeScale = 1.0f;
			//Left direction
			if (Input.GetKey (KeyCode.LeftArrow)) {
				if (direction == Vector3.right) {
					direction = (0.5f)*Vector3.forward + Vector3.right;

				}
			} 
			//right direction
			else if (Input.GetKey (KeyCode.RightArrow)) {
				if (direction == Vector3.right) {
					direction = (0.5f)*Vector3.back + Vector3.right;
				}
			} 
			//jumping direction
			else if (Input.GetKeyDown(KeyCode.Space)) {
				if (onTerrain) {
					playerAnim.Play ("Jump");
					Aj.AddForce (0.0f,6.0f,0.0f,ForceMode.Impulse);
				}
			}
			//running direction
			else {
				direction = Vector3.right;
			} 

			speed+=0.01f;

			Vector3 newPos = transform.position + speed * Time.fixedDeltaTime * direction;
			//Clamp z axis(-4,4)
			newPos.z = Mathf.Clamp (newPos.z, -4.0f, 4.0f);
			//Smooth position
			Vector3 smoothedPosition = Vector3.Lerp(transform.position, newPos, 0.5f);
			transform.position = smoothedPosition;
		}


	}

	//check collider
	void OnTriggerEnter(Collider other) {
	
		//pick up capsule
		if (other.tag == "Capsule") {
			other.gameObject.SetActive (false);	
			GameObject PSclone = Instantiate (ps, transform.position, Quaternion.identity) as GameObject;
			Destroy(PSclone,1.0f);
			score++;
			scoreText.text = score.ToString ();
		}
		//pick up FirstAid box
		else if (other.tag == "FirstAid") {
			other.gameObject.SetActive (false);	
			if (health > 0 && health < 3) {
				health++;
				healthText.text = health.ToString ();
			}
		} 
		//collision danger box
		else {
			other.gameObject.SetActive (false);	
				health--;
				speed--;
				healthText.text = health.ToString ();
			if (health <= 0) {

				GameOver ();

			}
		}

	}
	//Pause Functiom
	public void Pause(){
		
		isPaused = !isPaused;
	}
	//Game over function
	private void GameOver(){
		
		PlayerStats.Score = score;
		if (score > PlayerStats.BestScore) {
			PlayerStats.BestScore = score;
		}
		SceneManager.LoadSceneAsync (2);
	}

}